/*
 * Decompiled with CFR 0.152.
 */
package adql.query.from;

import adql.db.DBColumn;
import adql.db.DBTable;
import adql.db.DefaultDBTable;
import adql.db.SearchColumnList;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.IdentifierField;
import adql.query.TextPosition;
import adql.query.from.FromContent;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class ADQLTable
implements ADQLObject,
FromContent {
    private String catalog = null;
    private String schema = null;
    private String table;
    private ADQLQuery subQuery;
    private String alias = null;
    private byte caseSensitivity = 0;
    private DBTable dbLink = null;
    private TextPosition position = null;

    public ADQLTable(String string) {
        this.setTable(string);
        this.subQuery = null;
    }

    public ADQLTable(String string, String string2) {
        this(string2);
        this.setSchemaName(string);
    }

    public ADQLTable(String string, String string2, String string3) {
        this(string2, string3);
        this.setCatalogName(string);
    }

    public ADQLTable(ADQLQuery aDQLQuery) {
        this.setSubQuery(aDQLQuery);
    }

    public ADQLTable(ADQLTable aDQLTable) throws Exception {
        this.catalog = aDQLTable.catalog;
        this.schema = aDQLTable.schema;
        this.table = aDQLTable.table;
        this.subQuery = aDQLTable.subQuery == null ? null : (ADQLQuery)aDQLTable.subQuery.getCopy();
        this.alias = aDQLTable.alias;
        this.caseSensitivity = aDQLTable.caseSensitivity;
        this.position = aDQLTable.position;
    }

    protected String normalizeName(String string, IdentifierField identifierField) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.trimToSize();
        if (stringBuffer.length() == 0) {
            return null;
        }
        if (stringBuffer.length() > 1 && stringBuffer.charAt(0) == '\"' && stringBuffer.charAt(stringBuffer.length() - 1) == '\"') {
            stringBuffer.deleteCharAt(0);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.trimToSize();
            if (stringBuffer.length() == 0) {
                return null;
            }
            this.setCaseSensitive(identifierField, true);
        }
        return stringBuffer.toString();
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition textPosition) {
        this.position = textPosition;
    }

    public final String getCatalogName() {
        return this.catalog;
    }

    public final void setCatalogName(String string) {
        String string2 = this.normalizeName(string, IdentifierField.CATALOG);
        if (this.catalog == null && string2 != null || this.catalog != null && !this.catalog.equalsIgnoreCase(string2)) {
            this.dbLink = null;
        }
        this.catalog = string2;
    }

    public final String getSchemaName() {
        return this.schema;
    }

    public final void setSchemaName(String string) {
        String string2 = this.normalizeName(string, IdentifierField.SCHEMA);
        if (this.schema == null && string2 != null || this.schema != null && !this.schema.equalsIgnoreCase(string2)) {
            this.dbLink = null;
        }
        this.schema = string2;
    }

    public final String getTableName() {
        return this.table;
    }

    public final String getFullTableName() {
        if (this.table == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.catalog != null) {
            if (this.isCaseSensitive(IdentifierField.CATALOG)) {
                stringBuffer.append('\"').append(this.catalog).append('\"').append('.');
            } else {
                stringBuffer.append(this.catalog).append('.');
            }
        }
        if (this.schema != null) {
            if (this.isCaseSensitive(IdentifierField.SCHEMA)) {
                stringBuffer.append('\"').append(this.schema).append('\"').append('.');
            } else {
                stringBuffer.append(this.schema).append('.');
            }
        }
        if (this.isCaseSensitive(IdentifierField.TABLE)) {
            stringBuffer.append('\"').append(this.table).append('\"');
        } else {
            stringBuffer.append(this.table);
        }
        return stringBuffer.toString();
    }

    public void setTableName(String string) {
        String string2 = this.normalizeName(string, IdentifierField.TABLE);
        if (this.table == null && string2 != null || this.table != null && !this.table.equalsIgnoreCase(string2)) {
            this.dbLink = null;
        }
        this.table = string2;
        if (this.table != null) {
            this.subQuery = null;
        }
    }

    public final void setTable(String string) {
        String[] stringArray;
        String[] stringArray2 = stringArray = string == null ? null : string.split("\\.");
        if (stringArray != null && stringArray.length > 3) {
            return;
        }
        int n = stringArray == null ? -1 : stringArray.length - 1;
        this.setTableName(n < 0 ? null : stringArray[n--]);
        this.setSchemaName(n < 0 ? null : stringArray[n--]);
        this.setCatalogName(n < 0 ? null : stringArray[n]);
        if (this.table != null) {
            this.subQuery = null;
        }
    }

    public final ADQLQuery getSubQuery() {
        return this.subQuery;
    }

    public final void setSubQuery(ADQLQuery aDQLQuery) {
        if (aDQLQuery != null) {
            this.subQuery = aDQLQuery;
            this.catalog = null;
            this.schema = null;
            this.table = null;
            this.dbLink = null;
            this.position = null;
            this.refreshDBLink();
        }
    }

    public final void refreshDBLink() {
        if (this.isSubQuery() && this.hasAlias()) {
            DBColumn[] dBColumnArray;
            DefaultDBTable defaultDBTable = new DefaultDBTable(this.alias);
            for (DBColumn dBColumn : dBColumnArray = this.subQuery.getResultingColumns()) {
                defaultDBTable.addColumn(dBColumn.copy(dBColumn.getADQLName(), dBColumn.getADQLName(), defaultDBTable));
            }
            this.dbLink = defaultDBTable;
        }
    }

    public final boolean isSubQuery() {
        return this.subQuery != null;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final boolean hasAlias() {
        return this.alias != null;
    }

    public void setAlias(String string) {
        this.alias = this.normalizeName(string, IdentifierField.ALIAS);
    }

    public final boolean isCaseSensitive(IdentifierField identifierField) {
        return identifierField.isCaseSensitive(this.caseSensitivity);
    }

    public final void setCaseSensitive(IdentifierField identifierField, boolean bl) {
        this.caseSensitivity = identifierField.setCaseSensitive(this.caseSensitivity, bl);
    }

    public final boolean isCaseSensitive() {
        return IdentifierField.isFullCaseSensitive(this.caseSensitivity);
    }

    public final void setCaseSensitive(boolean bl) {
        this.caseSensitivity = IdentifierField.getFullCaseSensitive(bl);
    }

    public final byte getCaseSensitive() {
        return this.caseSensitivity;
    }

    public final void setCaseSensitive(byte by) {
        this.caseSensitivity = by;
    }

    public final DBTable getDBLink() {
        return this.dbLink;
    }

    public final void setDBLink(DBTable dBTable) {
        if (!this.isSubQuery()) {
            this.dbLink = dBTable;
        }
    }

    @Override
    public SearchColumnList getDBColumns() {
        SearchColumnList searchColumnList = new SearchColumnList();
        if (this.isSubQuery() && this.dbLink == null) {
            this.refreshDBLink();
        }
        if (this.dbLink != null) {
            for (DBColumn dBColumn : this.dbLink) {
                searchColumnList.add(dBColumn);
            }
        }
        return searchColumnList;
    }

    @Override
    public ArrayList<ADQLTable> getTables() {
        ArrayList<ADQLTable> arrayList = new ArrayList<ADQLTable>();
        arrayList.add(this);
        return arrayList;
    }

    @Override
    public ArrayList<ADQLTable> getTablesByAlias(String string, boolean bl) {
        ArrayList<ADQLTable> arrayList = new ArrayList<ADQLTable>();
        if (this.hasAlias()) {
            if (!bl) {
                if (this.getAlias().equalsIgnoreCase(string)) {
                    arrayList.add(this);
                }
            } else if (IdentifierField.ALIAS.isCaseSensitive(this.caseSensitivity)) {
                if (this.getAlias().equals(string)) {
                    arrayList.add(this);
                }
            } else if (this.getAlias().toLowerCase().equals(string)) {
                arrayList.add(this);
            }
        }
        return arrayList;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ADQLTable(this);
    }

    @Override
    public String getName() {
        return this.hasAlias() ? this.alias : (this.isSubQuery() ? "{subquery}" : this.getTableName());
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean subQueryGot;
            {
                this.subQueryGot = !ADQLTable.this.isSubQuery();
            }

            @Override
            public ADQLObject next() {
                if (!this.subQueryGot) {
                    this.subQueryGot = true;
                    return ADQLTable.this.subQuery;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return !this.subQueryGot;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                }
                if (!(aDQLObject instanceof ADQLQuery)) {
                    throw new UnsupportedOperationException("Impossible to replace a sub-query (" + ADQLTable.this.subQuery.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                }
                ADQLTable.this.subQuery = (ADQLQuery)aDQLObject;
            }

            @Override
            public void remove() {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the sub-query of an ADQLTable (" + ADQLTable.this.toADQL() + ") !");
            }
        };
    }

    @Override
    public String toADQL() {
        return (this.isSubQuery() ? "(" + this.subQuery.toADQL() + ")" : this.getFullTableName()) + (this.alias == null ? "" : " AS " + (this.isCaseSensitive(IdentifierField.ALIAS) ? "\"" + this.alias + "\"" : this.alias));
    }
}

